## Sample project configuration

Your sample must contain two configuration files.

- google-services.json
- onespan-notifications.properties

### google-services.json

This file must be downloaded from your [Firebase project](https://firebase.google.com).

Go to `Console -> Select Project -> Project Settings -> General tab`.

Retrieve `google-services.json` file and replace the one inside the `app` sample project repository.

### onespan-notifications.properties

This file must be put in the `assets` repository. The content of this file is described below.

```
notificationMIMEType=application/vnd.com.vasco.notification.NOTIFICATION_ACTIVITY
notificationIconName=ic_notification
notificationIconNameLollipop=ic_notification_lollipop
notificationIconBackgroundColorLollipop=#848484
```

##### MIMEType

`notificationMIMEType` value must be the same as the one specified in sample `AndroidManifest.xml`.

```
<activity>
    …
    <intent-filter>
        <action android:name="android.intent.action.VIEW" />
        <category android:name="android.intent.category.DEFAULT" />
        <data android:mimeType="application/vnd.com.vasco.notification.NOTIFICATION_ACTIVITY"/>
    </intent-filter>
    …
</activity>
```

> MIMEType must be unique per project.

#### Image files
Image files must be referenced in sample `res/drawable` repository. Can be **.png**, **.jpg**, **.jpeg**, **.xml**, **.webp**, **.avif** types.

## Send notification

To test notification you could use the [OneSpan Java or DotNet Server Sample] or direcly from your [Firebase console](https://firebase.google.com/docs/cloud-messaging/send-with-console).
